#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")

#install.packages("reshape2")
#install.packages("ggpubr")


#library packages
library(limma)
library(reshape2)
library(ggpubr)

expFile="GeneExp.txt"          #expression data file
geneCluFile="metabolismcluster.txt"     #Results file for d typing
setwd("E:\\metabolism\\LGG\\17.Model_gene\\1.ClusterDiff\\CGGA")       

#Read expression input file
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=t(data)

#Read the d typing file
geneClu=read.table(geneCluFile, header=T, sep="\t", check.names=F, row.names=1)

#data merge
sameSample=intersect(row.names(data), row.names(geneClu))
expClu=cbind(data[sameSample,,drop=F], geneClu[sameSample,,drop=F])

#Extract significantly different genes
sigGene=c()
for(i in colnames(expClu)[1:(ncol(expClu)-1)]){
	if(sd(expClu[,i])<0.001){next}
	if(length(levels(factor(expClu[,"metabolismcluster"])))>2){
		test=kruskal.test(expClu[,i] ~ expClu[,"metabolismcluster"])
	}else{
		test=wilcox.test(expClu[,i] ~ expClu[,"metabolismcluster"])
	}
	pvalue=test$p.value
	if(pvalue<1){
		sigGene=c(sigGene, i)
	}
}
sigGene=c(sigGene, "metabolismcluster")
expClu=expClu[,sigGene]

#Convert data to ggplot2 input file
data=melt(expClu, id.vars=c("metabolismcluster"))
colnames(data)=c("metabolismcluster", "Gene", "Expression")

#set color
bioCol=c("#415DB9","#EC5D3B","#FF0000","#6E568C","#7CC767","#223D6C","#D20A13","#FFD121","#088247","#11AA4D")
bioCol=bioCol[1:length(levels(factor(data[,"metabolismcluster"])))]

#draw a boxplot
p=ggboxplot(data, x="Gene", y="Expression", color = "metabolismcluster",
	     xlab="",
	     ylab="Gene expression",
	     legend.title="metabolismcluster",
	     palette = bioCol,
	     width=1)
p=p+rotate_x_text(60)
p1=p+stat_compare_means(aes(group=metabolismcluster),
	      symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),
	      label = "p.signif")

#output a boxplot
pdf(file="boxplot.pdf", width=4, height=5)
print(p1)
dev.off()


